<?php
/**
 * Copyright (C) 2014-2018 ServMask Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
 */

abstract class Ai1wm_Http_Abstract {

	protected $headers = array(
		'Accept'          => '*/*',
		'Accept-Encoding' => '*',
		'Accept-Charset'  => '*',
		'Accept-Language' => '*',
		'User-Agent'      => 'Mozilla/5.0',
	);

	public function __construct() {
		// Set user agent
		if ( isset( $_SERVER['HTTP_USER_AGENT'] ) ) {
			$this->headers['User-Agent'] = $_SERVER['HTTP_USER_AGENT'];
		}
	}

	public function set_header( $key, $value ) {
		$this->headers[ $key ] = $value;

		return $this;
	}

	public function get_header( $key ) {
		return $this->headers[ $key ];
	}

	abstract public function get( $url, $blocking = false );
}
